/******************************************************************************

                              Online C++ Compiler.
               Code, Compile, Run and Debug C++ program online.
Write your code in this editor and press "Run" button to compile and execute it.

*******************************************************************************/

#include <iostream>
#include <vector>
#include <unordered_map>
#include <bitset>
#include <functional>

using namespace std;


const size_t BLOOM_FILTER_SIZE = 1e6; 
bitset<BLOOM_FILTER_SIZE> bloomFilter;


size_t hashState(const vector<int>& binaryArr, int idx) {
    size_t hash = 0;
    for (int bit : binaryArr) {
        hash = hash * 31 + bit;
    }
    return (hash ^ idx) % BLOOM_FILTER_SIZE;
}


vector<int> computeBinaryArray(const vector<int>& arr) {
    vector<int> binaryArr;
    for (int num : arr) {
        binaryArr.push_back(num % 2); 
    }
    return binaryArr;
}


int calculateCounterWeight(const vector<int>& binaryArr) {
    int counterWeight = 0;
    int n = binaryArr.size();

    for (size_t i = 0; i < n - 1; ++i) {
        if (binaryArr[i] == binaryArr[i + 1]) {
            ++counterWeight;
        }
    }

    return counterWeight;
}

int findMaximumCounterWeightRecursive(vector<int>& binaryArr, int idx, unordered_map<size_t, int>& dp) {
    size_t stateHash = hashState(binaryArr, idx);

    if (bloomFilter[stateHash]) {
        return dp[stateHash];
    }

    int currentCounterWeight = calculateCounterWeight(binaryArr);

    int maxCounterWeight = currentCounterWeight;

    for (int i = idx; i < binaryArr.size() - 1; i += 2) {
        swap(binaryArr[i], binaryArr[i + 1]);

        maxCounterWeight = max(maxCounterWeight, findMaximumCounterWeightRecursive(binaryArr, i + 2, dp));

        swap(binaryArr[i], binaryArr[i + 1]);
    }

    dp[stateHash] = maxCounterWeight;
    bloomFilter[stateHash] = true;

    return maxCounterWeight;
}

int findMaximumCounterWeight(const vector<int>& arr) {
    vector<int> binaryArr = computeBinaryArray(arr);

    unordered_map<size_t, int> dp;

    return findMaximumCounterWeightRecursive(binaryArr, 0, dp);
}

int main() {
    int exampleCount;
    cin >> exampleCount; 

    for (int example = 1; example <= exampleCount; ++example) {
        int n;
        cin >> n; 

        vector<int> oddElements(n), evenElements(n);
        for (int i = 0; i < n; ++i) {
            cin >> oddElements[i];
        }
        for (int i = 0; i < n; ++i) {
            cin >> evenElements[i];
        }

        
        vector<int> arr(2 * n);
        for (int i = 0; i < n; ++i) {
            arr[2 * i] = oddElements[i];     
            arr[2 * i + 1] = evenElements[i]; 
        }

        int maxCounterWeight = findMaximumCounterWeight(arr);

        cout << maxCounterWeight << endl;
    }

    return 0;
}